//basic PIC32 FLASH implementation
//virtual EEPROM in RAM

#ifndef _FLASH_H    /* Guard against multiple inclusion */
#define _FLASH_H
#include <xc.h>
//for #defines
#include "settings.h"

//PIC32MX1xx/2xx have 1kB page size
#define FLASH_PAGE_SIZE 1024
#define FLASH_PAGES_IN_USE 1
#define FLASH_ROW_SIZE 128

//NVMCON settings
#define NVM_PAGE_ERASE (0x4004) 
#define NVM_ROW_WRITE (0x4003) 
#define NVM_WORD_WRITE (0x4001) 

const uint32_t __attribute__ ((aligned(FLASH_PAGE_SIZE))) flashImage[FLASH_PAGE_SIZE*FLASH_PAGES_IN_USE/4]={
    UART_MODE_ASCII,UART_LE_CRLF,9600,0        //set initial default here
};
uint32_t RAMImage[FLASH_PAGE_SIZE*FLASH_PAGES_IN_USE/4];

void loadToRAM();           //perhaps a bit wasteful, but allows in place editing
uint32_t saveToFlash();     //uses the pointers above
uint32_t flashOperation(uint32_t nvmOp);     //perform unlock sequence and operation as required
unsigned int VirtToPhys(volatile void* p);   //get physical address

#endif /* _FLASH_H */
